/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.settings.snmp;

import com.ibm.hwmca.base.managed.BaseTower;
import com.ibm.hwmca.base.settings.network.FirewallAdmin;
import com.ibm.hwmca.base.settings.network.FirewallAdminException;
import com.ibm.hwmca.base.settings.snmp.SnmpErrorIds;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.shutdown.ShutdownListener;
import com.ibm.hwmca.fw.shutdown.ShutdownManager;
import com.ibm.hwmca.fw.shutdown.ShutdownRequest;
import com.ibm.hwmca.fw.util.RootProcess;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;

public class Snmpd
implements Runnable,
ShutdownListener,
SnmpErrorIds {
    private static final String TRACE_MASKT = "XSNMPD T";
    private static final String TRACE_MASKF = "XSNMPD F";
    private static final String TRACE_MASKD = "XSNMPD D";
    private static final String SNMPD_CONF_FILE = "snmpd.conf";
    private static final String DATA_DIR = "data";
    private static final String SNMPD_PID_FILE = "snmpd.pid";
    private static final String TMP_DIR = "tmp";
    private static final String START_SNMPD_SCRIPT = "startSNMPD";
    private static final String STOP_SNMPD_SCRIPT = "stopSNMPD";
    private static final String SNMP_PORT = "161";
    private static ShutdownManager shutdownManager = ShutdownManager.getShutdownManager();

    public void run() {
        block10: {
            Trace.trace(TRACE_MASKT, "-> Snmpd.run()");
            try {
                BaseTower baseTower;
                File snmpdPidFile = new File(BaseFileControl.getFilePath(TMP_DIR) + SNMPD_PID_FILE);
                if (snmpdPidFile.exists()) {
                    snmpdPidFile.delete();
                }
                if ((baseTower = BaseTower.getBaseTower()).isSnmpEnabled()) {
                    File snmpdConfFile = new File(BaseFileControl.getFilePath(SNMPD_CONF_FILE) + SNMPD_CONF_FILE);
                    if (snmpdConfFile.exists()) {
                        Trace.trace(TRACE_MASKF, "Snmpd.run(): SNMP is enabled for the console and snmpd.conf exists, now starting the SNMP daemon...");
                        String[] snmpdStartCmd = new String[]{START_SNMPD_SCRIPT, BaseFileControl.getFilePath(DATA_DIR) + SNMPD_CONF_FILE, BaseFileControl.getFilePath(TMP_DIR) + SNMPD_PID_FILE, baseTower.getSnmpAgentParameters()};
                        int i = 0;
                        while (i < snmpdStartCmd.length) {
                            Trace.trace(TRACE_MASKD, "Snmpd.run(): snmpdStartCmd[" + i + "] = " + snmpdStartCmd[i]);
                            ++i;
                        }
                        int rc = RootProcess.executeProgram(snmpdStartCmd);
                        Trace.trace(TRACE_MASKF, "Snmpd.run(): rc = " + rc);
                        if (rc == 0) {
                            Trace.trace(TRACE_MASKF, "Snmpd.run(): The SNMP daemon was successfully started!");
                            try {
                                FirewallAdmin.getFirewallAdmin().addRuleForAllInterfaces("0.0.0.0", "0.0.0.0", "udp", SNMP_PORT);
                            }
                            catch (FirewallAdminException e) {
                                Trace.trace(TRACE_MASKF, e);
                            }
                            shutdownManager.addShutdownListener(this);
                            break block10;
                        }
                        Trace.trace(TRACE_MASKF, "Snmpd.run(): The SNMP daemon failed to start!");
                        String cmd = "";
                        int i2 = 0;
                        while (i2 < snmpdStartCmd.length) {
                            cmd = cmd + " " + snmpdStartCmd[i2];
                            ++i2;
                        }
                        HException hexc = new HException("The SNMP daemon failed to start.");
                        Trace.trace(TRACE_MASKF, hexc);
                        FrameworkLog log = new FrameworkLog(SnmpErrorIds.LOG_INFO, 2131, hexc);
                        log.add(cmd);
                        log.log();
                        break block10;
                    }
                    Trace.trace(TRACE_MASKF, "Snmpd.run(): The snmpd.conf file does not exist, not starting the SNMP daemon.");
                    break block10;
                }
                Trace.trace(TRACE_MASKF, "Snmpd.run(): SNMP is not enabled for the console, not starting the SNMP daemon.");
            }
            catch (Exception exc) {
                Trace.trace(TRACE_MASKF, exc);
                new FrameworkLog(SnmpErrorIds.LOG_INFO, 2131, exc).log();
            }
        }
        Trace.trace(TRACE_MASKT, "<- Snmpd.run()");
    }

    /*
     * Unable to fully structure code
     */
    public void shutdownStarting(ShutdownRequest request, long delay) {
        block5: {
            Trace.trace("XSNMPD T", "Snmpd.shutdownStarting(" + request + ", " + delay + ")");
            try {
                block6: {
                    snmpdPidFile = new File(BaseFileControl.getFilePath("tmp") + "snmpd.pid");
                    if (!snmpdPidFile.exists() || !snmpdPidFile.canRead()) break block6;
                    fileReader = new FileReader(snmpdPidFile);
                    bufferedReader = new BufferedReader(fileReader);
                    pid = bufferedReader.readLine();
                    bufferedReader.close();
                    if (pid == null) ** GOTO lbl28
                    Trace.trace("XSNMPD D", "Snmpd.shutdownStarting(): pid = " + pid);
                    snmpdStopCmd = new String[]{"stopSNMPD", pid, BaseFileControl.getFilePath("tmp") + "snmpd.pid"};
                    i = 0;
                    while (i < snmpdStopCmd.length) {
                        Trace.trace("XSNMPD D", "Snmpd.shutdownStarting(): snmpdStopCmd[" + i + "] = " + snmpdStopCmd[i]);
                        ++i;
                    }
                    rc = RootProcess.executeProgram(snmpdStopCmd);
                    Trace.trace("XSNMPD F", "Snmpd.shutdownStarting(): rc = " + rc);
                    if (rc == 0) {
                        Trace.trace("XSNMPD F", "Snmpd.shutdownStarting(): The SNMP daemon process was successfully killed!");
                        snmpdPidFile.delete();
                        Snmpd.shutdownManager.removeShutdownListener(this);
                    } else {
                        Trace.trace("XSNMPD F", "Snmpd.shutdownStarting(): An error occured while trying to kill the SNMP daemon process!");
                        throw new HException("The SNMP daemon failed to be stopped.");
lbl28:
                        // 1 sources

                        Trace.trace("XSNMPD F", "Snmpd.shutdownStarting(): The pid returned from the pid file is null!");
                    }
                    break block5;
                }
                Trace.trace("XSNMPD F", "Snmpd.shutdownStarting(): The SNMP pid file does not exist or is not readable.");
            }
            catch (Exception exc) {
                Trace.trace("XSNMPD F", exc);
                new FrameworkLog(SnmpErrorIds.LOG_INFO, 2132, exc).log();
            }
        }
        Trace.trace("XSNMPD T", "Snmpd.shutdownStarting()");
    }
}

